export default {
  async fetch(request, env) {
    const url = new URL(request.url);
    if (!url.pathname.startsWith("/ipfs/")) {
      return new Response("Not found", { status: 404 });
    }

    if (request.method !== "GET" && request.method !== "HEAD") {
      return new Response("Method not allowed", { status: 405 });
    }

    const originBase = (env.ORIGIN_GATEWAY_BASE || "").replace(/\/+$/, "");
    const fallbackBase = (env.FALLBACK_GATEWAY_BASE || "https://dweb.link").replace(/\/+$/, "");

    if (!originBase) {
      return new Response("ORIGIN_GATEWAY_BASE is required", { status: 500 });
    }

    let originHost = "";
    try {
      originHost = new URL(originBase).host;
    } catch (_) {
      return new Response("ORIGIN_GATEWAY_BASE is invalid", { status: 500 });
    }
    if (originHost === url.host) {
      const fallbackURL = fallbackBase + url.pathname + url.search;
      return Response.redirect(fallbackURL, 302);
    }

    const originURL = originBase + url.pathname + url.search;
    try {
      const originResponse = await fetch(originURL, request);
      if (originResponse.ok) {
        return originResponse;
      }
    } catch (_) {
      // fall through to fallback
    }

    const fallbackURL = fallbackBase + url.pathname + url.search;
    return Response.redirect(fallbackURL, 302);
  },
};
